# UltraTopUp-Laravel

**UltraTopUp-Laravel** adalah backend API untuk aplikasi UltraTopUp yang dibangun dengan framework Laravel. Backend ini menyediakan layanan transaksi top-up pulsa, paket data, dan layanan digital secara otomatis dengan keamanan dan stabilitas tinggi.

---

## Deskripsi

UltraTopUp-Laravel bertugas sebagai core system dari platform UltraTopUp yang mengatur autentikasi user, manajemen produk, integrasi provider topup, manajemen transaksi, notifikasi, hingga dashboard admin.

---

## Fitur-Fitur

- **Manajemen User** – Registrasi, login, pengaturan profil & hak akses
- **Transaksi TopUp Otomatis** – Melayani pulsa, data, PPOB, dsb
- **Integrasi Multi Provider** – Mudah integrasi dengan berbagai provider
- **Manajemen Produk & Harga** – CRUD layanan digital & harga jual
- **Riwayat & Status Transaksi** – Pantau dan telusuri histori transaksi
- **Admin Dashboard** – Monitoring data, aktivitas user, keuangan
- **Laporan & Statistik** – Mendukung laporan untuk kebutuhan analisa
- **Sistem Notifikasi** – Email / WhatsApp (opsional)
- **Keamanan** – Otentikasi, validasi, dan manajemen user yang baik

---

## Struktur Direktori (Umum Laravel)

```
├── app/
│   ├── Console/
│   ├── Exceptions/
│   ├── Http/
│   └── Models/
├── bootstrap/
├── config/
├── database/
│   ├── factories/
│   ├── migrations/
│   └── seeders/
├── public/
├── resources/
│   ├── views/
│   └── lang/
├── routes/
│   ├── api.php
│   └── web.php
├── storage/
├── tests/
├── .env.example
├── composer.json
└── README.md
```

---

## Instalasi & Deploy di VPS aaPanel

### Prasyarat

- PHP >= 8.0 (disarankan 8.1+)
- Composer
- MySQL/MariaDB
- aaPanel (web server management)
- Git (untuk clone repo)

### Langkah Instalasi & Deploy

1. **Clone Project**
    ```bash
    git clone https://github.com/ferdianandaid/UltraTopUp-Laravel.git
    cd UltraTopUp-Laravel
    ```

2. **Update & Install Dependency**
    ```bash
    composer self-update
    composer update
    ```

3. **Generate Key & Konfigurasi Environment**
    - Copy atau edit file .env sesuai kebutuhan environment (`cp .env.example .env`)
    - Sesuaikan konfigurasi DB, mail, dsb di .env
    - Generate app key:
      ```bash
      php artisan key:generate
      ```

4. **Jalankan Migrasi, Linking, dan Seeder**
    ```bash
    php artisan migrate
    php artisan storage:link
    php artisan db:seed
    php artisan vendor:publish --force --tag=livewire:assets
    ```

5. **Atur Permission Folder**
    ```bash
    chmod -R 775 storage bootstrap/cache
    ```

6. **Konfigurasi Domain/Subdomain di aaPanel**
    - Point domain ke folder `public/`
    - (Opsional) Setting SSL Let’s Encrypt via aaPanel

7. **Restart Webserver (Nginx/Apache)**

8. **(Opsional) Supervisor untuk Queue**
    - Untuk job/background processing: Setup supervisor proses di VPS

---

## Panduan Akses

- API dapat diakses di: `https://<domain-kamu>/api`
- Dokumentasi endpoint (kalau tersedia): `/docs` atau Postman Collection

---

## Bantuan & Kontak

Jika Memerlukan Bantuan, Silahkan Chat Ke WhatsApp:

[![Chat WhatsApp](https://img.shields.io/badge/WhatsApp-Chat-green?logo=whatsapp)](https://wa.me/6285155088505)

---

<<<<<<< HEAD
UltraTopUp — Solusi TopUp Otomatis Pulsa & Layanan Digital
=======
UltraTopUp — Solusi TopUp Otomatis Pulsa & Layanan Digital
>>>>>>> 66e8c25 (feat: fix some displays to make them better)
