<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Http\Controllers\PaymentChannelController;

class FetchPaymentChannels extends Command
{
    protected $signature = 'payment:fetch-channels {provider=tripay}';
    protected $description = 'Ambil dan perbarui daftar channel pembayaran dari Tripay atau PayDisini';

    public function handle()
    {
        $provider = $this->argument('provider');
        $controller = new PaymentChannelController();

        $controller->fetchChannels($provider);

        $this->info("Payment channels dari {$provider} berhasil diperbarui.");
    }
}