<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use App\Models\Order;

class PaymentStatusUpdated implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $order;

    public function __construct(Order $order)
    {
        $this->order = $order;
    }

    public function broadcastOn()
    {
        return new Channel('payments');
    }

    public function broadcastAs()
    {
        return 'payment.updated';
    }

    public function broadcastWith()
    {
        return [
            'order_id' => $this->order->order_id,
            'payment_status' => $this->order->payment_status,
            'buy_status' => $this->order->buy_status,
        ];
    }
}