<?php

namespace App\Events;

use App\Models\Order;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class RealtimeTransaction implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public Order $order;

    public function __construct(Order $order)
    {
        $this->order = $order;
    }

    public function broadcastOn(): Channel
    {
        return new Channel('realtimetransaction');
    }

    public function broadcastAs(): string
    {
        return 'realtimetransaction.updated';
    }

    public function broadcastWith(): array
    {
        return [
            'order_id' => $this->order->order_id,
            'product' => $this->order->product,
            'price' => (int) ($this->order->price ?? 0),
            'whatsapp' => $this->order->whatsapp,
            'buy_status' => $this->order->buy_status,
            'updated_at' => $this->order->updated_at?->toIso8601String(),
        ];
    }
}