<?php

namespace App\Filament\Pages\Settings;

use Closure;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Tabs;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Outerweb\FilamentSettings\Filament\Pages\Settings as BaseSettings;

class Settings extends BaseSettings
{
    protected static ?string $navigationGroup = 'Manajemen Website';

    public function schema(): array|Closure
    {
        return [
            Tabs::make('Settings')
                ->schema([
                    Tabs\Tab::make('General')
                        ->schema([
                            TextInput::make('general.title')
                                ->label('Judul Website')
                                ->required(),

                            TextInput::make('seo.title')
                                ->label('Meta Title')
                                ->required(),

                            Textarea::make('seo.description')
                                ->label('Meta Description')
                                ->required(),

                            Textarea::make('seo.keywords')
                                ->label('Meta Keywords')
                                ->required(),

                            FileUpload::make('general.logo')
                                ->label('Upload Logo')
                                ->image()
                                ->disk('public')
                                ->directory('logo'),

                            FileUpload::make('general.favicon')
                                ->label('Upload Favicon')
                                ->image()
                                ->disk('public')
                                ->directory('favicon'),
                        ]),

                    Tabs\Tab::make('Sosial Media')
                        ->schema([
                            TextInput::make('sosmed.fb')
                                ->label('Facebook')
                                ->prefix('https://facebook.com/')
                                ->required(),

                            TextInput::make('sosmed.ig')
                                ->label('Instagram')
                                ->prefix('https://instagram.com/')
                                ->required(),

                            TextInput::make('sosmed.wa')
                                ->label('WhatsApp')
                                ->prefix('https://wa.me/')
                                ->required(),
                        ]),

                    Tabs\Tab::make('OTP')
                        ->schema([
                            TextInput::make('otp.length')
                                ->label('Panjang OTP')
                                ->numeric()
                                ->minValue(4)
                                ->maxValue(8)
                                ->required(),

                            TextInput::make('otp.expiry_minutes')
                                ->label('Expired (menit)')
                                ->numeric()
                                ->minValue(1)
                                ->maxValue(60)
                                ->required(),

                            TextInput::make('otp.max_attempts')
                                ->label('Max Percobaan')
                                ->numeric()
                                ->minValue(1)
                                ->maxValue(20)
                                ->required(),

                            TextInput::make('otp.resend_cooldown_seconds')
                                ->label('Cooldown Kirim Ulang (detik)')
                                ->numeric()
                                ->minValue(10)
                                ->maxValue(600)
                                ->required(),
                        ]),

                    Tabs\Tab::make('reCaptcha Turnstile')
                        ->schema([
                            Toggle::make('turnstile.enabled')
                                ->label('Aktifkan Turnstile')
                                ->default(false),

                            TextInput::make('turnstile.site_key')
                                ->label('Site Key (Public)')
                                ->helperText('Ambil dari Cloudflare Turnstile → Site Key')
                                ->required(fn (callable $get) => (bool) $get('turnstile.enabled')),

                            TextInput::make('turnstile.secret_key')
                                ->label('Secret Key (Server)')
                                ->password()
                                ->revealable()
                                ->helperText('Rahasia, hanya untuk server. Jangan dibagikan.')
                                ->required(fn (callable $get) => (bool) $get('turnstile.enabled')),
                        ]),

                    Tabs\Tab::make('Digiflazz')
                        ->schema([
                            TextInput::make('digi.username')->password()->revealable(),
                            TextInput::make('digi.apikey')->password()->revealable(),
                            TextInput::make('digi.secret')->password()->revealable(),
                            TextInput::make('digi.profit')->label('Profit Basic'),
                            TextInput::make('digi.profit_gold'),
                            TextInput::make('digi.profit_platinum'),
                        ]),

                    Tabs\Tab::make('SMP Payment')
                        ->schema([
                            TextInput::make('smp.username')
                                ->label('SMP Username')
                                ->required(),

                            TextInput::make('smp.callback_secret')
                                ->label('Callback Secret')
                                ->password()
                                ->revealable()
                                ->required(),

                            TextInput::make('smp.qris_string')
                                ->label('QRIS String')
                                ->required(),

                            TextInput::make('smp.expires_minutes')
                                ->label('Kadaluarsa (menit)')
                                ->numeric()
                                ->default(60)
                                ->required(),

                            TextInput::make('smp.unique_digits')
                                ->label('Digit Unik')
                                ->numeric()
                                ->default(2)
                                ->required(),
                        ]),

                    Tabs\Tab::make('QRISPY')
                        ->schema([
                            Toggle::make('qrispy.enabled')
                                ->label('Aktifkan QRISPY')
                                ->default(false),

                            TextInput::make('qrispy.display_name')
                                ->label('Nama Tampilan')
                                ->default('QRIS (Qrispy)')
                                ->required(),

                            TextInput::make('qrispy.api_token')
                                ->label('API Token')
                                ->password()
                                ->revealable()
                                ->required(fn (callable $get) => (bool) $get('qrispy.enabled')),

                            TextInput::make('qrispy.webhook_secret')
                                ->label('Webhook Secret')
                                ->password()
                                ->revealable()
                                ->required(fn (callable $get) => (bool) $get('qrispy.enabled')),

                            TextInput::make('qrispy.expiry_seconds')
                                ->label('Kadaluarsa (detik)')
                                ->numeric()
                                ->minValue(60)
                                ->maxValue(86400)
                                ->default(900)
                                ->required(fn (callable $get) => (bool) $get('qrispy.enabled')),

                            TextInput::make('qrispy.reference_prefix')
                                ->label('Reference Prefix')
                                ->default('Order-')
                                ->required(fn (callable $get) => (bool) $get('qrispy.enabled')),

                            Toggle::make('qrispy.use_base64')
                                ->label('Gunakan QR Base64 di Invoice')
                                ->default(false),
                        ]),

                    Tabs\Tab::make('Tripay')
                        ->schema([
                            TextInput::make('tripay.merchant')->password()->revealable(),
                            TextInput::make('tripay.apikey')->password()->revealable(),
                            TextInput::make('tripay.privatekey')->password()->revealable(),
                        ]),

                    Tabs\Tab::make('Duitku')
                        ->schema([
                            TextInput::make('duitku.merchant')->password()->revealable(),
                            TextInput::make('duitku.apikey')->password()->revealable(),
                        ]),
                ]),
        ];
    }
}
