<?php

namespace App\Filament\Resources;

use App\Filament\Resources\GameConfigurationResource\Pages;
use App\Filament\Resources\GameConfigurationResource\RelationManagers;
use App\Models\GameConfiguration;
use App\Models\Game;
use Filament\Forms\Components;
use Filament\Forms\Components\CheckboxList;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\FileUpload;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class GameConfigurationResource extends Resource
{
    protected static ?string $model = GameConfiguration::class;
    
    protected static ?string $navigationGroup = 'Manajemen Game';
    
    protected static ?string $navigationLabel = 'Konfigurasi';
    protected static ?string $pluralModelLabel = 'Konfigurasi Game';

    protected static ?string $navigationIcon = 'heroicon-o-adjustments-horizontal';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                  Forms\Components\Select::make('game_name')
                      ->label('Pilih Game')
                      ->options(function () {
                          $usedGames = GameConfiguration::pluck('game_name')->toArray();
                          return Game::whereNotIn('title', $usedGames)
                              ->pluck('title', 'title')
                              ->toArray();
                      })
                      ->searchable()
                      ->required(),
                Forms\Components\CheckboxList::make('required_inputs')
                    ->options([
                        'id' => 'ID Akun',
                        'server' => 'Server',
                    ])
                    ->columns(3)
                    ->required(),

                Components\Repeater::make('input_fields')
                    ->label('Input Fields')
                    ->schema([
                        Components\Select::make('name')
                            ->label('Nama Input')
                            ->required()
                            ->reactive()
                            ->options(function (callable $get) {
                                $allOptions = [
                                    'id' => 'ID',
                                    'server' => 'Server',
                                ];
                
                                $fields = $get('../../input_fields') ?? [];
                                $usedNames = collect($fields)
                                    ->pluck('name')
                                    ->filter()
                                    ->values();
                                    
                                $currentName = $get('name');
                                if ($currentName) {
                                    $usedNames = $usedNames->filter(fn($name) => $name !== $currentName);
                                }
                
                                return collect($allOptions)
                                    ->reject(fn($label, $key) => $usedNames->contains($key))
                                    ->toArray();
                            }),
                
                        Components\TextInput::make('label')
                            ->label('Label')
                            ->required(),
                
                        Components\TextInput::make('placeholder')
                            ->label('Placeholder')
                            ->required(),
                
                        Components\Select::make('type')
                            ->label('Tipe Input')
                            ->options([
                                'text' => 'Text',
                                'number' => 'Number',
                                'email' => 'Email',
                            ])
                            ->default('text')
                            ->required(),
                    ])
                    ->columns(2)
                    ->collapsed()
                    ->maxItems(2),
                Forms\Components\Repeater::make('options')
                    ->label('Opsi Server')
                    ->schema([
                        TextInput::make('label')
                            ->label('Nama Server')
                            ->required(),
                
                        TextInput::make('value')
                            ->label('Value Server')
                            ->required(),
                    ])
                    ->columnSpanFull()
                    ->collapsed(),
                Forms\Components\Textarea::make('guide_text')
                    ->columnSpanFull(),
                Forms\Components\FileUpload::make('guide_image')
                    ->disk('public')
                    ->directory('panduan')
                    ->image(),
                Forms\Components\Select::make('code_validation_nickname')
                    ->label('Validasi Nickname')
                    ->options([
                        'ml' => 'Mobile Legends',
                        'ff' => 'Free Fire',
                        'ag' => 'Aether Gazer',
                        'aov' => 'Arena Of Valor',
                        'cod' => 'Call Of Duty',
                        'gi' => 'Genshin Impact',
                        'hi' => 'Honkai Impact 3rd',
                        'hsr' => 'Honkai: Star Rail',
                        'la' => 'LifeAfter',
                        'lad' => 'Love and Deepspace',
                        'pb' => 'Point Blank',
                        'pgr' => 'Punishing: Gray Raven',
                        'sus' => 'Sausage Man',
                        'valo' => 'VALORANT',
                        'zzz' => 'Zenless Zone Zero',
                    ])
                    ->searchable()
                    ->nullable(),
                Forms\Components\Select::make('status_validation_nickname')
                    ->label('Status Validasi Nickname')
                    ->options([
                        'Yes' => 'Yes',
                        'No' => 'No',
                    ])
                    ->required(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\ImageColumn::make('guide_image'),
                Tables\Columns\TextColumn::make('game_name')
                    ->searchable(),
                Tables\Columns\TextColumn::make('required_inputs')
                    ->searchable(),
                Tables\Columns\TextColumn::make('options')
                    ->searchable(),
                Tables\Columns\TextColumn::make('code_validation_nickname')
                    ->searchable(),
                Tables\Columns\TextColumn::make('status_validation_nickname'),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListGameConfigurations::route('/'),
            'create' => Pages\CreateGameConfiguration::route('/create'),
            'edit' => Pages\EditGameConfiguration::route('/{record}/edit'),
        ];
    }
}
