<?php

namespace App\Filament\Resources;

use App\Filament\Resources\OrderResource\Pages;
use App\Filament\Resources\OrderResource\RelationManagers;
use App\Models\Order;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Filters\SelectFilter;
use Filament\Tables\Filters\Filter;

class OrderResource extends Resource
{
    protected static ?string $model = Order::class;
    
    protected static ?string $navigationLabel = 'Order';
    protected static ?string $pluralModelLabel = 'Daftar Order';

    protected static ?string $navigationIcon = 'heroicon-o-clipboard-document-list';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('order_id')->disabled(),
                Forms\Components\TextInput::make('games')->disabled(),
                Forms\Components\TextInput::make('product')->disabled(),
                Forms\Components\TextInput::make('code_product')->disabled(),
                Forms\Components\TextInput::make('id_games')->disabled(),
                Forms\Components\TextInput::make('server_games')->disabled(),
                Forms\Components\TextInput::make('nickname')->disabled(),
                Forms\Components\TextInput::make('email')->disabled(),
                Forms\Components\TextInput::make('whatsapp')->disabled(),
                Forms\Components\TextInput::make('code_voucher')->disabled(),
                Forms\Components\TextInput::make('price')->disabled(),
                Forms\Components\TextInput::make('discount_price')->disabled(),
                Forms\Components\TextInput::make('profit')->disabled(),
                Forms\Components\TextInput::make('total_price')->disabled(),
                Forms\Components\TextInput::make('payment_name')->disabled(),
                Forms\Components\TextInput::make('payment_method')->disabled(),
                Forms\Components\TextInput::make('payment_code')->disabled(),
                Forms\Components\TextInput::make('expired_time')->disabled(),
                Forms\Components\Select::make('payment_status')
                    ->options([
                        'PAID' => 'PAID',
                        'UNPAID' => 'UNPAID',
                        'EXPIRED' => 'EXPIRED',
                        'FAILED' => 'FAILED',
                    ])
                    ->required(),
                    
                Forms\Components\Select::make('buy_status')
                    ->options([
                        'Sukses' => 'Sukses',
                        'Pending' => 'Pending',
                        'Gagal' => 'Gagal',
                        'Batal' => 'Batal',
                    ])
                    ->required(),
    
                Forms\Components\TextInput::make('serial_number')->disabled(),
                Forms\Components\Textarea::make('df_message')->disabled(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->defaultSort('created_at', 'desc')
            ->columns([
                Tables\Columns\TextColumn::make('order_id')
                    ->searchable(),
                Tables\Columns\TextColumn::make('games')
                    ->searchable(),
                Tables\Columns\TextColumn::make('product')
                    ->searchable(),
                Tables\Columns\TextColumn::make('price')
                    ->money('IDR')
                    ->sortable(),
                Tables\Columns\TextColumn::make('discount_price')
                    ->money('IDR')
                    ->sortable(),
                Tables\Columns\TextColumn::make('profit')
                    ->money('IDR')
                    ->sortable(),
                Tables\Columns\TextColumn::make('id_games')
                    ->searchable(),
                Tables\Columns\TextColumn::make('server_games')
                    ->searchable(),
                Tables\Columns\TextColumn::make('whatsapp')
                    ->searchable(),
                Tables\Columns\TextColumn::make('payment_name')
                    ->searchable(),
                Tables\Columns\TextColumn::make('payment_status')
                    ->label('Status Pembayaran')
                    ->badge()
                    ->color(fn ($state) => match ($state) {
                        'UNPAID' => 'warning',
                        'PAID' => 'success',
                        'FAILED' => 'danger',
                        'EXPIRED' => 'danger',
                        default => 'gray',
                    }),
                
                Tables\Columns\TextColumn::make('buy_status')
                    ->label('Status Pembelian')
                    ->badge()
                    ->color(fn ($state) => match ($state) {
                        'Pending' => 'warning',
                        'Sukses' => 'success',
                        'Batal' => 'danger',
                        'Gagal' => 'danger',
                        default => 'gray',
                    }),
                Tables\Columns\TextColumn::make('created_at')
                    ->label('Waktu Transaksi')
                    ->dateTime()
                    ->sortable(),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                // Filter Buy Status
                SelectFilter::make('buy_status')
                    ->label('Status Pembelian')
                    ->options([
                        'Pending' => 'Pending',
                        'Sukses' => 'Sukses',
                        'Batal' => 'Batal',
                        'Gagal' => 'Gagal',
                    ])
                    ->default(null)
                    ->attribute('buy_status'),
            
                // Filter Payment Status
                SelectFilter::make('payment_status')
                    ->label('Status Pembayaran')
                    ->options([
                        'UNPAID' => 'PAID',
                        'PAID' => 'PAID',
                        'FAILED' => 'FAILED',
                        'EXPIRED' => 'EXPIRED',
                    ])
                    ->default(null)
                    ->attribute('payment_status'),
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }
    
    public static function canCreate(): bool
    {
        return false;
    }
    
    public static function getNavigationBadge(): ?string
    {
        return (string) \App\Models\Order::where('buy_status', 'Sukses')
            ->count();
    }
    
    public static function getNavigationBadgeColor(): ?string
    {
        return 'success';
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListOrders::route('/'),
            'edit' => Pages\EditOrder::route('/{record}/edit'),
        ];
    }
}
