<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ProfitResource\Pages;
use App\Models\Profit;
use App\Models\Game;
use Filament\Forms;
use Filament\Resources\Resource;
use Filament\Tables;

class ProfitResource extends Resource {
    protected static ?string $model = Profit::class;
    
    protected static ?string $navigationGroup = 'Manajemen Game';
    protected static ?string $navigationLabel = 'Profit';
    protected static ?string $pluralModelLabel = 'Profit';
    protected static ?string $navigationIcon = 'heroicon-o-currency-dollar';

    public static function form(Forms\Form $form): Forms\Form {
        return $form->schema([
            Forms\Components\Select::make('game_id')
                ->label('Pilih Game')
                ->options(function () {
                    $gamesWithProfit = \App\Models\Profit::pluck('game_id')->toArray();
                    return \App\Models\Game::whereNotIn('id', $gamesWithProfit)->pluck('title', 'id');
                })
                ->searchable()
                ->helperText('hanya menampilkan daftar game yang belum memiliki profit')
                ->required()
                ->preload(),

            Forms\Components\TextInput::make('profit_percentage')
                ->label('Profit Basic (%)')
                ->numeric()
                ->minValue(0)
                ->required(),
            Forms\Components\TextInput::make('profit_gold_percentage')
                ->label('Profit Gold (%)')
                ->numeric()
                ->minValue(0)
                ->required(),
            Forms\Components\TextInput::make('profit_platinum_percentage')
                ->label('Profit Platinum (%)')
                ->numeric()
                ->minValue(0)
                ->required(),
        ]);
    }

    public static function table(Tables\Table $table): Tables\Table {
        return $table
        ->columns([
            Tables\Columns\ImageColumn::make('game.image'),
            Tables\Columns\TextColumn::make('game.title')
              ->label('Game')
              ->searchable(),
            Tables\Columns\TextColumn::make('profit_percentage')->label('Profit Basic (%)'),
            Tables\Columns\TextColumn::make('profit_gold_percentage')->label('Profit Gold (%)'),
            Tables\Columns\TextColumn::make('profit_platinum_percentage')->label('Profit Platinum (%)'),
        ])
        ->actions([
            Tables\Actions\EditAction::make(),
        ]);
    }

    public static function getPages(): array {
        return [
            'index' => Pages\ListProfits::route('/'),
            'edit' => Pages\EditProfit::route('/{record}/edit'),
        ];
    }
}
