<?php

namespace App\Filament\Resources;

use App\Filament\Resources\PromoResource\Pages;
use App\Models\Promo;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;

class PromoResource extends Resource
{
    protected static ?string $model = Promo::class;

    protected static ?string $navigationIcon = 'heroicon-o-arrow-up-on-square-stack';
    
    protected static ?string $navigationGroup = 'Manajemen Website';
    protected static ?string $navigationLabel = 'Pop-up';
    protected static ?string $pluralModelLabel = 'Pop-up';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('title')
                    ->required()
                    ->maxLength(255),
                    
                Forms\Components\Textarea::make('description')
    ->label('Deskripsi')
    ->rows(4)
    ->nullable()
    ->maxLength(1000),

                Forms\Components\TextInput::make('link')
                    ->url()
                    ->label('Tautan (Opsional)')
                    ->nullable(),

                Forms\Components\FileUpload::make('image_url')
                    ->label('Gambar')
                    ->required()
                    ->image()
                    ->imageEditor()
                    ->directory('promos'),

                Forms\Components\DateTimePicker::make('start_at')
                    ->label('Tampilkan Mulai')
                    ->nullable(),

                Forms\Components\DateTimePicker::make('end_at')
                    ->label('Tampilkan Sampai')
                    ->nullable(),

                Forms\Components\Toggle::make('is_active')
                    ->label('Aktifkan Promo')
                    ->default(true),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\ImageColumn::make('image_url')
                    ->label('Gambar')
                    ->width(100)
                    ->height(60),

                Tables\Columns\TextColumn::make('title')
                    ->searchable()
                    ->limit(40),

                Tables\Columns\ToggleColumn::make('is_active')
                    ->label('Aktif'),

                Tables\Columns\TextColumn::make('start_at')
                    ->label('Mulai')
                    ->dateTime(),

                Tables\Columns\TextColumn::make('end_at')
                    ->label('Sampai')
                    ->dateTime(),
            ])
            ->defaultSort('start_at', 'desc')
            ->filters([])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [];
    }
    
    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPromos::route('/'),
            'create' => Pages\CreatePromo::route('/create'),
            'edit' => Pages\EditPromo::route('/{record}/edit'),
        ];
    }
}