<?php

namespace App\Filament\Resources;

use App\Filament\Resources\TransactionResource\Pages;
use App\Filament\Resources\TransactionResource\Widgets;
use App\Models\Order;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Carbon\Carbon;

class TransactionResource extends Resource
{
    protected static ?string $model = Order::class;
    
    protected static ?string $pluralModelLabel = 'Data Transaksi';
    protected static ?string $navigationLabel = 'Data Transaksi';

    protected static ?string $navigationIcon = 'heroicon-o-queue-list';

    public static function getWidgets(): array
    {
        return [
            Widgets\TransactionStats::class,
        ];
    }
    
    public static function getPages(): array
    {
        return [
            'index' => Pages\ListTransaction::route('/'),
        ];
    }
}