<?php

namespace App\Filament\Widgets;

use App\Models\Product;
use App\Models\Game;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Card;

class GameAndProductWidget extends BaseWidget
{
    protected function getCards(): array
    {
        return [
            Card::make('Total Products', Product::count())
                ->icon('heroicon-o-document-text')
                ->description('Total produk yang tersedia')
                ->color('primary'),

            Card::make('Total Games', Game::count())
                ->icon('heroicon-o-cube')
                ->description('Total game yang tersedia')
                ->color('success'),
        ];
    }

    protected function getColumns(): int
    {
        return 2; // Atur jumlah kolom untuk menampilkan 2 card dalam satu baris
    }
}