<?php

namespace App\Filament\Widgets;

use App\Models\Order;
use Filament\Widgets\BarChartWidget;
use Illuminate\Support\Carbon;
use Livewire\Attributes\Url;

class OrderStatusChart extends BarChartWidget
{
    protected static ?string $heading = 'Grafik Transaksi';

    #[Url]
    public ?string $filter = 'today';

    protected function getData(): array
    {
        $dateRange = $this->getDateRange();
        
        return [
            'datasets' => [
                [
                    'label' => 'Pending',
                    'data' => [Order::where('buy_status', 'Pending')->whereBetween('created_at', $dateRange)->count()],
                    'backgroundColor' => 'rgba(255, 193, 7, 0.6)',
                ],
                [
                    'label' => 'Sukses',
                    'data' => [Order::where('buy_status', 'Sukses')->whereBetween('created_at', $dateRange)->count()],
                    'backgroundColor' => 'rgba(40, 167, 69, 0.6)',
                ],
                [
                    'label' => 'Batal',
                    'data' => [Order::where('buy_status', 'Batal')->whereBetween('created_at', $dateRange)->count()],
                    'backgroundColor' => 'rgba(220, 53, 69, 0.6)',
                ],
            ],
            'labels' => ['Order Status'],
        ];
    }

    private function getDateRange(): array
    {
        $now = Carbon::now();
    
        return match ($this->filter) {
            'today' => [Carbon::today(), Carbon::now()],
            'this_week' => [$now->copy()->startOfWeek(), $now->copy()->endOfWeek()],
            'this_month' => [$now->copy()->startOfMonth(), $now->copy()->endOfMonth()],
            'this_year' => [$now->copy()->startOfYear(), $now->copy()->endOfYear()],
            default => [Carbon::minValue(), Carbon::now()],
        };
    }

    protected function getFilters(): ?array
    {
        return [
            'today' => 'Hari Ini',
            'this_week' => 'Minggu Ini',
            'this_month' => 'Bulan Ini',
            'this_year' => 'Tahun Ini',
        ];
    }
}