<?php

namespace App\Filament\Widgets;

use App\Models\Order;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Card;

class TransactionToday extends BaseWidget
{
    protected function getCards(): array
    {
        return [
            Card::make('Profit', 'Rp ' . number_format(
                    Order::whereDate('created_at', today())
                        ->where('buy_status', 'Sukses')
                        ->sum('profit'),
                    0,
                    ',',
                    '.'
                )
            )
            ->icon('heroicon-o-clock')
            ->description('Total profit hari ini')
            ->color('dark'),
                
            Card::make('Sukses', Order::whereDate('created_at', today())->where('buy_status', 'Sukses')->count())
                ->icon('heroicon-o-clock')
                ->description('Total transaksi sukses hari ini')
                ->color('success'),
                
            Card::make('Pending', Order::whereDate('created_at', today())->where('buy_status', 'Pending')->count())
                ->icon('heroicon-o-clock')
                ->description('Total transaksi pending hari ini')
                ->color('warning'),

            Card::make('Gagal', Order::whereDate('created_at', today())->where('buy_status', 'Gagal')->count())
                ->icon('heroicon-o-x-circle')
                ->description('Total transaksi gagal hari ini')
                ->color('danger'),

            Card::make('Batal', Order::whereDate('created_at', today())->where('buy_status', 'Batal')->count())
                ->icon('heroicon-o-document-text')
                ->description('Total transaksi batal hari ini')
                ->color('gray'),
        ];
    }

    protected function getColumns(): int
    {
        return 4;
    }
}