<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Setting;

class SettingController extends Controller
{
    public function index()
    {
        $settings = Setting::all()->pluck('value', 'key');

        $allowedKeys = [
            'general.title',
            'general.logo',
            'general.favicon',
            'seo.title',
            'seo.description',
            'seo.keywords',
            'sosmed.fb',
            'sosmed.ig',
            'sosmed.wa',

            'otp.length',
            'otp.expiry_minutes',
            'otp.max_attempts',
            'otp.resend_cooldown_seconds',

            'turnstile.enabled',
            'turnstile.site_key',

            'qrispy.enabled',
            'qrispy.display_name',
            'qrispy.use_base64',
        ];

        $filtered = $settings->only($allowedKeys)->toArray();

        if (isset($filtered['general.logo'])) {
            $filtered['general.logo'] = asset('storage/' . $filtered['general.logo']);
        }

        if (isset($filtered['general.favicon'])) {
            $filtered['general.favicon'] = asset('storage/' . $filtered['general.favicon']);
        }

        $filtered['turnstile.enabled'] = filter_var($filtered['turnstile.enabled'] ?? false, FILTER_VALIDATE_BOOLEAN);
        $filtered['qrispy.enabled'] = filter_var($filtered['qrispy.enabled'] ?? false, FILTER_VALIDATE_BOOLEAN);
        $filtered['qrispy.use_base64'] = filter_var($filtered['qrispy.use_base64'] ?? false, FILTER_VALIDATE_BOOLEAN);

        if (!isset($filtered['qrispy.display_name']) || $filtered['qrispy.display_name'] === null || $filtered['qrispy.display_name'] === '') {
            $filtered['qrispy.display_name'] = 'QRIS (Qrispy)';
        }

        return response()->json([
            'success' => true,
            'data' => $filtered,
        ]);
    }
}
