<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Slider;
use Illuminate\Http\Request;

class SliderController extends Controller
{
    public function index()
    {
        $data = Slider::all()->map(function ($item) {
            $item->images = asset('storage/' . $item->images);
            return $item;
        });
    
        return response()->json([
            'success' => true,
            'data' => $data,
        ]);
    }
}
