<?php

namespace App\Http\Middleware;

use App\Models\User;
use Closure;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class JwtMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        $token = $request->bearerToken();

        if (!$token) {
            return response()->json([
                'message' => 'Unauthorized: Missing token',
            ], Response::HTTP_UNAUTHORIZED);
        }

        try {
            $decoded = JWT::decode($token, new Key((string) env('NEXTAUTH_SECRET'), 'HS256'));
            $decodedArray = (array) $decoded;

            if (!isset($decodedArray['email'])) {
                return response()->json([
                    'message' => 'Unauthorized: Invalid token structure',
                ], Response::HTTP_UNAUTHORIZED);
            }

            $user = User::query()->where('email', (string) $decodedArray['email'])->first();

            if (!$user) {
                return response()->json([
                    'message' => 'User not found',
                ], Response::HTTP_NOT_FOUND);
            }

            Auth::loginUsingId($user->id);
            $request->merge(['auth_user' => $user]);
        } catch (\Throwable $e) {
            return response()->json([
                'message' => 'Unauthorized: Invalid token',
            ], Response::HTTP_UNAUTHORIZED);
        }

        return $next($request);
    }
}