<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PromoCodeListRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    protected function prepareForValidation(): void
    {
        $gameSlug = $this->input('game_slug');
        if (!$gameSlug) $gameSlug = $this->query('game_slug');
        if (!$gameSlug) $gameSlug = $this->input('game');
        if (!$gameSlug) $gameSlug = $this->query('game');

        if (is_string($gameSlug)) {
            $gameSlug = trim($gameSlug);
        }

        $paymentMethodId = $this->input('payment_method_id');
        if ($paymentMethodId === null) $paymentMethodId = $this->query('payment_method_id');

        $productId = $this->input('product_id');
        if ($productId === null) $productId = $this->query('product_id');

        $this->merge([
            'game_slug' => $gameSlug ?: null,
            'payment_method_id' => $paymentMethodId !== null ? (int) $paymentMethodId : null,
            'product_id' => $productId !== null ? (int) $productId : null,
        ]);
    }

    public function rules(): array
    {
        return [
            'game_slug' => ['nullable', 'string', 'max:255'],
            'product_id' => ['nullable', 'integer'],
            'payment_method_id' => ['nullable', 'integer'],
        ];
    }
}