<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PromoCodeValidateRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    protected function prepareForValidation(): void
    {
        $gameSlug = $this->input('game_slug');

        if (!$gameSlug) {
            $gameSlug = $this->input('game');
        }

        if (is_string($gameSlug)) {
            $gameSlug = trim($gameSlug);
        }

        $code = $this->input('code');
        if (is_string($code)) {
            $code = strtoupper(trim($code));
        }

        $whatsapp = $this->input('whatsapp');
        if (is_string($whatsapp)) {
            $w = preg_replace('/[^0-9]/', '', $whatsapp);
            if (str_starts_with($w, '0')) $w = '62' . substr($w, 1);
            if ($w !== '' && !str_starts_with($w, '62')) $w = '62' . $w;
            $whatsapp = $w !== '' ? $w : null;
        }

        $this->merge([
            'game_slug' => $gameSlug,
            'code' => $code,
            'whatsapp' => $whatsapp,
        ]);
    }

    public function rules(): array
    {
        return [
            'code' => ['required', 'string', 'max:64', 'regex:/^[A-Za-z0-9_-]+$/'],
            'game_slug' => ['required', 'string', 'max:255'],
            'product_id' => ['required', 'integer'],
            'payment_method_id' => ['required', 'integer'],
            'whatsapp' => ['nullable', 'string', 'max:32'],
        ];
    }
}
