<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Support\Str;

class Game extends Model
{
    use HasFactory;

    protected $fillable = [
        'image',
        'banner',
        'title',
        'developers',
        'brand',
        'category_id',
        'slug',
        'description',
        'status',
        'populer',
        'sort',
        'category_id',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($game) {
            if (empty($game->slug)) {
                $game->slug = Str::slug($game->title);
            }
        });
    }
    
    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }
    
    public function profit() {
        return $this->hasOne(Profit::class);
    }
    
    public function products()
    {
        return $this->hasMany(Product::class);
    }
}