<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;

    protected $fillable = [
        'order_id',
        'user_id',
        'games',
        'product',
        'type',
        'code_product',
        'id_games',
        'server_games',
        'nickname',
        'email',
        'whatsapp',
        'code_voucher',
        'price',
        'discount_price',
        'profit',
        'fee',
        'total_price',
        'payment_name',
        'payment_method',
        'payment_code',
        'expired_time',
        'payment_status',
        'buy_status',
        'payment_instructions',
        'serial_number',
        'df_message',
        'promo_code_id',
        'promo_code',
        'promo_discount',
        'qrispy_qris_id',
        'qrispy_image_url',
        'qrispy_image_base64',
        'qrispy_expires_at',
        'qrispy_paid_at',
        'qrispy_webhook_unique_id',
    ];

    protected $casts = [
        'price' => 'integer',
        'discount_price' => 'integer',
        'promo_discount' => 'integer',
        'profit' => 'integer',
        'total_price' => 'integer',
        'payment_instructions' => 'array',
        'qrispy_expires_at' => 'datetime',
        'qrispy_paid_at' => 'datetime',
    ];
}
