<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $fillable = [
        'code',
        'images',
        'banner',
        'title',
        'brand',
        'type',
        'category',
        'seller_name',
        'seller_price',
        'profit',
        'profit_gold',
        'profit_platinum',
        'selling_price',
        'selling_price_gold',
        'selling_price_platinum',
        'description',
        'type_transaction',
        'provider',
        'buyer_product_status',
        'seller_product_status',
        'unlimited_stock',
        'stock',
        'multi',
        'start_cut_off',
        'end_cut_off',
        'status',
    ];

    protected $appends = ['game_slug'];

    protected $casts = [
        'buyer_product_status' => 'boolean',
        'seller_product_status' => 'boolean',
        'unlimited_stock' => 'boolean',
        'multi' => 'boolean',
        'status' => 'boolean',
    ];

    public function categoryRelation()
    {
        return $this->belongsTo(ProductCategory::class, 'category', 'id');
    }

    public function logo()
    {
        return $this->belongsTo(ProductLogo::class, 'brand', 'brand');
    }

    public function gameByBrand()
    {
        return $this->hasOne(Game::class, 'brand', 'brand');
    }

    public function getGameSlugAttribute()
    {
        return optional($this->gameByBrand)->slug;
    }

    public function promotions()
    {
        return $this->hasMany(ProductPromotion::class);
    }

    public function activePromotion()
    {
        return $this->hasOne(ProductPromotion::class)
            ->active()
            ->latest('start_at');
    }

    public function getPromoPriceAttribute()
    {
        $activePromotion = $this->activePromotion;

        if ($activePromotion && now()->between($activePromotion->start_at, $activePromotion->end_at)) {
            return $activePromotion->promo_price;
        }

        return null;
    }

    public function game()
    {
        return $this->belongsTo(Game::class);
    }
}