<?php

namespace App\Services;

use App\Models\Setting;
use Illuminate\Support\Facades\Http;

class TurnstileService
{
    public function isEnabled(): bool
    {
        $enabled = Setting::query()->where('key', 'turnstile.enabled')->value('value');
        return filter_var($enabled ?? false, FILTER_VALIDATE_BOOLEAN);
    }

    public function verify(?string $token, ?string $ip = null): bool
    {
        if (! $this->isEnabled()) {
            return true;
        }

        $token = is_string($token) ? trim($token) : '';
        if ($token === '') {
            return false;
        }

        $secret = (string) (Setting::query()->where('key', 'turnstile.secret_key')->value('value') ?? '');
        if ($secret === '') {
            return false;
        }

        $payload = [
            'secret' => $secret,
            'response' => $token,
        ];

        if (is_string($ip) && $ip !== '') {
            $payload['remoteip'] = $ip;
        }

        $res = Http::asForm()
            ->timeout(8)
            ->post('https://challenges.cloudflare.com/turnstile/v0/siteverify', $payload);

        if (! $res->ok()) {
            return false;
        }

        $json = $res->json();
        return (bool) ($json['success'] ?? false);
    }
}
