<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('game_configurations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('game_name');
            $table->json('required_inputs');
            $table->json('options');
            $table->text('guide_text')->nullable();
            $table->json('guide_image')->nullable();
            $table->string('code_validation_nickname')->nullable();
            $table->enum('status_validation_nickname', ['yes', 'no'])->default('no');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('game_configurations');
    }
};
