<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('games', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('image');
            $table->string('banner');
            $table->string('title');
            $table->string('developers')->nullable();
            $table->string('brand');
            $table->string('category_id')->index('category');
            $table->string('slug');
            $table->text('description');
            $table->boolean('status')->default(true);
            $table->boolean('populer')->default(false);
            $table->integer('sort')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('games');
    }
};
