<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('game_accounts', function (Blueprint $table) {
            $table->id();
            $table->string('code_account')->unique();
            $table->string('email');
            $table->string('password');
            $table->string('email_recovery')->nullable();
            $table->string('password_recovery')->nullable();
            $table->string('link_webmail')->nullable();
            $table->text('descriptions')->nullable();
            $table->integer('stok')->default(0);
            $table->enum('status', ['available', 'sold', 'inactive'])->default('available');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('game_accounts');
    }
};