<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('qris_payments', function (Blueprint $t) {
            $t->id();
            $t->unsignedBigInteger('order_pk')->nullable();
            $t->string('order_id')->nullable();
            $t->bigInteger('amount_base');
            $t->integer('unique_code')->default(0);
            $t->bigInteger('amount_total');
            $t->enum('status', ['pending','paid','expired','canceled'])->default('pending');
            $t->timestamp('paid_at')->nullable();
            $t->timestamp('expires_at');
            $t->string('match_tx_at')->nullable();
            $t->string('match_sender')->nullable();
            $t->json('meta')->nullable();
            $t->timestamps();
            $t->index(['order_id','status']);
        });
    }
    public function down(): void {
        Schema::dropIfExists('qris_payments');
    }
};