<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->string('seller_name')->nullable()->after('brand');
            $table->boolean('buyer_product_status')->default(true)->after('provider');
            $table->boolean('seller_product_status')->default(true)->after('buyer_product_status');
            $table->boolean('unlimited_stock')->default(true)->after('seller_product_status');
            $table->unsignedInteger('stock')->default(0)->after('unlimited_stock');
            $table->boolean('multi')->default(false)->after('stock');
            $table->string('start_cut_off')->nullable()->after('multi');
            $table->string('end_cut_off')->nullable()->after('start_cut_off');
        });
    }

    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn([
                'seller_name',
                'buyer_product_status',
                'seller_product_status',
                'unlimited_stock',
                'stock',
                'multi',
                'start_cut_off',
                'end_cut_off',
            ]);
        });
    }
};
