<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('promo_codes', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('code')->unique();
            $table->boolean('is_active')->default(true);
            $table->timestamp('start_at')->nullable();
            $table->timestamp('end_at')->nullable();
            $table->enum('discount_type', ['PERCENT', 'FLAT']);
            $table->unsignedBigInteger('discount_value');
            $table->unsignedBigInteger('min_product_price')->nullable();
            $table->unsignedBigInteger('usage_limit_total')->nullable();
            $table->unsignedBigInteger('usage_limit_per_user')->nullable();
            $table->unsignedBigInteger('used_count')->default(0);
            $table->timestamps();
            $table->index(['is_active', 'start_at', 'end_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('promo_codes');
    }
};