<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('promo_code_game', function (Blueprint $table) {
            $table->unsignedBigInteger('promo_code_id');
            $table->unsignedBigInteger('game_id');
            $table->timestamps();

            $table->primary(['promo_code_id', 'game_id']);
            $table->foreign('promo_code_id')->references('id')->on('promo_codes')->cascadeOnDelete();
            $table->foreign('game_id')->references('id')->on('games')->cascadeOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('promo_code_game');
    }
};