<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('payment_methods', function (Blueprint $table) {
            $table->boolean('is_outside_group')->default(false)->after('status');
            $table->string('badge_text')->nullable()->after('is_outside_group');
            $table->unsignedInteger('outside_sort')->default(0)->after('badge_text');
        });
    }

    public function down(): void
    {
        Schema::table('payment_methods', function (Blueprint $table) {
            $table->dropColumn(['is_outside_group', 'badge_text', 'outside_sort']);
        });
    }
};