<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('whatsapp_password_reset_tokens', function (Blueprint $table) {
            $table->id();
            $table->string('whatsapp', 191)->index();
            $table->string('token_hash', 191)->index();
            $table->timestamp('expires_at')->nullable()->index();
            $table->timestamp('consumed_at')->nullable()->index();
            $table->string('ip', 64)->nullable();
            $table->text('user_agent')->nullable();
            $table->timestamps();

            $table->unique(['whatsapp', 'token_hash']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('whatsapp_password_reset_tokens');
    }
};