<x-filament::page>
    <div class="flex flex-col gap-3">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-3">
            <div class="text-sm text-gray-500 dark:text-gray-400">
                Menampilkan {{ $this->limit }} log terbaru
            </div>

            <div class="flex items-center gap-2">
                <x-filament::button
                    color="gray"
                    icon="heroicon-o-arrow-path"
                    onclick="window.location.reload()"
                >
                    Refresh
                </x-filament::button>

                <x-filament::button
                    color="danger"
                    icon="heroicon-o-trash"
                    wire:click="clearLog"
                >
                    Clear Log
                </x-filament::button>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-3">
            <div class="md:col-span-1">
                <x-filament::input.wrapper>
                    <x-filament::input.select wire:model.live="level">
                        <option value="ALL">Semua Level</option>
                        <option value="ERROR">ERROR</option>
                        <option value="WARNING">WARNING</option>
                        <option value="INFO">INFO</option>
                        <option value="DEBUG">DEBUG</option>
                    </x-filament::input.select>
                </x-filament::input.wrapper>
            </div>

            <div class="md:col-span-2">
                <x-filament::input.wrapper>
                    <x-filament::input
                        type="text"
                        wire:model.live.debounce.350ms="search"
                        placeholder="Cari keyword (message, stacktrace, dll)..."
                    />
                </x-filament::input.wrapper>
            </div>
        </div>
    </div>

    @php
        $logs = $this->getLogs();
    @endphp

    @if (count($logs) === 0)
        <x-filament::section>
            <div class="text-sm text-gray-600 dark:text-gray-300">
                Tidak ada log yang cocok.
            </div>
        </x-filament::section>
    @else
        <div class="space-y-4 mt-4">
            @foreach ($logs as $log)
                @php
                    $lvl = strtoupper($log['level'] ?? 'LOG');

                    if (in_array($lvl, ['ERROR', 'CRITICAL', 'ALERT', 'EMERGENCY'], true)) {
                        $badgeColor = 'danger';
                    } elseif ($lvl === 'WARNING') {
                        $badgeColor = 'warning';
                    } elseif (in_array($lvl, ['NOTICE', 'INFO'], true)) {
                        $badgeColor = 'info';
                    } else {
                        $badgeColor = 'gray';
                    }

                    $title = $log['message'] ?? $log['raw'];
                    $metaParts = [];
                    if (!empty($log['timestamp'])) $metaParts[] = $log['timestamp'];
                    if (!empty($log['env'])) $metaParts[] = strtoupper($log['env']);
                    if (!empty($log['level'])) $metaParts[] = strtoupper($log['level']);
                    $meta = implode(' • ', $metaParts);
                @endphp

                <x-filament::section>
                    <div
                        x-data="{
                            copied: false,
                            open: false,
                            text: @js($log['raw']),
                            async copy() {
                                try {
                                    await navigator.clipboard.writeText(this.text)
                                    this.copied = true
                                    setTimeout(() => this.copied = false, 1200)
                                } catch (e) {}
                            }
                        }"
                        class="space-y-3"
                    >
                        <div class="flex items-start justify-between gap-4">
                            <div class="min-w-0 space-y-2">
                                <div class="flex flex-wrap items-center gap-2">
                                    <x-filament::badge :color="$badgeColor">
                                        {{ $lvl }}
                                    </x-filament::badge>

                                    @if ($meta !== '')
                                        <div class="text-xs text-gray-500 dark:text-gray-400">
                                            {{ $meta }}
                                        </div>
                                    @endif
                                </div>

                                <div class="text-sm font-medium text-gray-900 dark:text-gray-100 break-words">
                                    {{ $title }}
                                </div>
                            </div>

                            <div class="flex shrink-0 items-center gap-2">
                                <x-filament::button
                                    color="gray"
                                    size="sm"
                                    icon="heroicon-o-clipboard"
                                    x-on:click="copy()"
                                >
                                    <span x-show="!copied">Copy</span>
                                    <span x-show="copied">Copied</span>
                                </x-filament::button>

                                <x-filament::button
                                    color="gray"
                                    size="sm"
                                    icon="heroicon-o-chevron-down"
                                    x-on:click="open = !open"
                                >
                                    Detail
                                </x-filament::button>
                            </div>
                        </div>

                        <div x-show="open" x-cloak class="rounded-xl bg-gray-50 dark:bg-gray-900 border border-gray-200 dark:border-gray-800 overflow-hidden">
                            <pre class="p-4 text-xs leading-relaxed text-gray-800 dark:text-gray-200 whitespace-pre-wrap break-words">{{ $log['raw'] }}</pre>
                        </div>
                    </div>
                </x-filament::section>
            @endforeach
        </div>
    @endif
</x-filament::page>