<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\SettingController;
use App\Http\Controllers\Api\SliderController;
use App\Http\Controllers\Api\CategoryController;
use App\Http\Controllers\Api\GameController;
use App\Http\Controllers\Api\OrderController;
use App\Http\Controllers\Api\InvoiceController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\OtpAuthController;
use App\Http\Controllers\Api\TransactionController;
use App\Http\Controllers\Api\PromoController;
use App\Http\Controllers\Api\PromoCodeController;
use App\Http\Controllers\Api\PopUpPromoController;
use App\Http\Controllers\Api\PriceListController;
use App\Http\Controllers\Api\BlogController;
use App\Http\Controllers\DigiflazzWebhookController;
use App\Http\Controllers\TripayCallbackController;
use App\Http\Controllers\PaydisiniCallbackController;
use App\Http\Controllers\DuitkuCallbackController;
use App\Http\Controllers\SmpQrisCallbackController;
use App\Http\Controllers\Api\QrispyWebhookController;
use App\Http\Middleware\ApiKeyMiddleware;

Route::post('/auth/register', [AuthController::class, 'register']);
Route::post('/auth/login', [AuthController::class, 'login']);

Route::post('/auth/google', [AuthController::class, 'googleAuth']);
Route::post('/auth/otp/request', [OtpAuthController::class, 'requestOtp']);
Route::post('/auth/otp/verify', [OtpAuthController::class, 'verifyOtp']);

Route::middleware(['jwt.auth'])->get('/auth/user', function (Request $request) {
    return response()->json(['user' => $request->user()]);
});

Route::get('/settings', [SettingController::class, 'index']);
Route::get('/sliders', [SliderController::class, 'index']);
Route::get('/category', [CategoryController::class, 'index']);
Route::get('/games', [GameController::class, 'index']);
Route::get('/games/{slug}', [GameController::class, 'show']);

Route::get('/price-list', [PriceListController::class, 'index']);
Route::get('/popup-promo', [PopUpPromoController::class, 'index']);
Route::get('/blogs', [BlogController::class, 'index']);
Route::get('/blogs/{slug}', [BlogController::class, 'show']);

Route::get('/promo', [PromoController::class, 'index']);
Route::post('/promo/validate', [PromoController::class, 'validatePromo']);

Route::get('/promo-codes', [PromoCodeController::class, 'index']);
Route::post('/promo-codes/validate', [PromoCodeController::class, 'validate']);

Route::get('/order/{slug}', [OrderController::class, 'index']);
Route::get('/order-config/{slug}', [OrderController::class, 'index']);
Route::post('/order', [OrderController::class, 'store']);

Route::get('/invoice/{order_id}', [InvoiceController::class, 'show']);
Route::get('/invoice/{order_id}/payment-status', [InvoiceController::class, 'paymentStatus']);
Route::get('/invoices/search', [InvoiceController::class, 'search']);
Route::get('/invoices/search-by-whatsapp', [InvoiceController::class, 'searchByWhatsapp']);

Route::get('/realtime-transaction', [InvoiceController::class, 'realtimeTransaction']);
Route::get('/transactions/realtime', [InvoiceController::class, 'realtimeTransaction']);

Route::withoutMiddleware([ApiKeyMiddleware::class])->group(function () {
    Route::post('/callback/tripay', [TripayCallbackController::class, 'handle']);
    Route::post('/callback/paydisini', [PaydisiniCallbackController::class, 'handle']);
    Route::post('/callback/duitku', [DuitkuCallbackController::class, 'handle']);
    Route::post('/callbackqris/{secret}', [SmpQrisCallbackController::class, 'handle']);
    Route::post('/digiflazz/webhook', [DigiflazzWebhookController::class, 'handleWebhook']);

    Route::post('/qrispy/webhook', [QrispyWebhookController::class, 'handle'])
        ->middleware('throttle:30,1');

    Route::post('/webhook', [QrispyWebhookController::class, 'handle'])
        ->middleware('throttle:30,1');
});

Route::middleware(['jwt.auth'])->group(function () {
    Route::get('/transactions', [TransactionController::class, 'index']);
    Route::get('/transactions/transaction-summary', [TransactionController::class, 'summary']);
    Route::get('/transactions/{order_id}', [TransactionController::class, 'show']);
});
